Attribute VB_Name = "Dimension"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.

Function DrawLinearDimension(design, drawdoc)

Dim CadStorm As Object
Set CadStorm = CreateObject("CadStorm.Application")

' Get the Drawing Object pointer
Dim Draw As ADrawing
Set Draw = drawdoc.GetDrawing

Dim ddetail As ADesignDetail
Set ddetail = Draw.GetDetail(design, False)

MsgBox ("Select two line items")

Dim Dummy As Object
Dim graphset As AObjectSet

'54 corresponds to LinearDimLineClass entry in FClass
Set graphset = drawdoc.GetSelection(2, 54)

' Get the paper geometry corresponding to the first selected item
Dim graph1 As AGraphic
Set graph1 = graphset.GetObjectAt(0)
Dim geom1 As ZGeometry
Set geom1 = drawdoc.GetPaperGeometry(graph1)

' Get the paper geometry corresponding to the second selected item
Dim graph2 As AGraphic
Set graph2 = graphset.GetObjectAt(1)
Dim geom2 As ZGeometry
Set geom2 = drawdoc.GetPaperGeometry(graph2)

' Get the Design Instance of the selected items
Dim view1 As AHiddenLine
Dim view2 As AHiddenLine
Set view1 = geom1.GetInstance
Set view2 = geom2.GetInstance

' create dimension
Dim defn As ZMidPlane
Set defn = drawdoc.CreateLinearDefn(geom1, geom2)
Dim Dimension As ADimension
Set Dimension = CadStorm.CreateDimension(ddetail, 1, defn)
    
'Set the position for the dimension line
Dim position As ZVector
Set position = CadStorm.CreateVectorXYZ(0.001, 0.001, 0)
    
' Create the linear dimension line
Dim LineDim As Object
Set LineDim = CadStorm.CreateLinearDimLine(position, Dimension, view1, view2)

Dim tolerance As ADimTol
Set tolerance = CadStorm.CreateDimTol(ddetail, Dimension)

Dim callout As ACallout
Set callout = CadStorm.CreateDimensionCallout(tolerance)

Dim text As ADimLineText
'Dim vector As ZVector
Set text = CadStorm.CreateDimLineText(LineDim, callout, position, 0.0035)

' 1 is for aCalloutGroup::topCenter
text.SetControlPoint 1, position
   
'Add the dimension line to the drawing.
Draw.AddDimLine LineDim
Draw.AddCenterLineUser LineDim

'Update the views

End Function

Function DrawAngularDimension(design, drawdoc)

Dim CadStorm As Object
Set CadStorm = CreateObject("CadStorm.Application")

' Get the Drawing Object pointer
Dim Draw As ADrawing
Set Draw = drawdoc.GetDrawing

Dim ddetail As ADesignDetail
Set ddetail = Draw.GetDetail(design, False)

MsgBox ("Select two line items")

Dim Dummy As Object
Dim graphset As AObjectSet

'54 corresponds to LinearDimLineClass entry in FClass
Set graphset = drawdoc.GetSelection(2, 54)

' Get the paper geometry corresponding to the first selected item
Dim graph1 As AGraphic
Set graph1 = graphset.GetObjectAt(0)
Dim geom1 As ZGeometry
Set geom1 = drawdoc.GetPaperGeometry(graph1)

' Get the paper geometry corresponding to the second selected item
Dim graph2 As AGraphic
Set graph2 = graphset.GetObjectAt(1)
Dim geom2 As ZGeometry
Set geom2 = drawdoc.GetPaperGeometry(graph2)

' Get the design Instance of selected items
Dim view1 As AHiddenLine
Dim view2 As AHiddenLine
Set view1 = geom1.GetInstance
Set view2 = geom2.GetInstance

'create dimension
Dim defn As ZMidPlane
Set defn = drawdoc.CreateAngularDefn(geom1, geom2)
Dim Dimension As ADimension
Set Dimension = CadStorm.CreateDimension(ddetail, 4, defn)
    
'Set the position for the dimension line
Dim position As ZVector
Set position = CadStorm.CreateVectorXYZ(0.2, 0.1, 0)
    
' Create the linear dimension line
Dim AngularDim As Object
Set AngularDim = CadStorm.CreateAngularDimLine(position, Dimension, view1, view2)
Dim tolerance As ADimTol
Set tolerance = CadStorm.CreateDimTol(ddetail, Dimension)

Dim callout As ACallout
Set callout = CadStorm.CreateDimensionCallout(tolerance)

Dim text As ADimLineText
Dim vector As ZVector
Set text = CadStorm.CreateDimLineText(AngularDim, callout, position, 0.0035)

' 1 is for aCalloutGroup::topCenter
text.SetControlPoint 1, position
   
'Add the dimension line to the drawing.
Draw.AddDimLine AngularDim
Draw.AddCenterLineUser AngularDim

'Update the views

End Function



Function DrawDiametricDimension(design, drawdoc)

Dim CadStorm As Object
Set CadStorm = CreateObject("CadStorm.Application")

' Get the Drawing Object pointer
Dim Draw As ADrawing
Set Draw = drawdoc.GetDrawing

Dim ddetail As ADesignDetail
Set ddetail = Draw.GetDetail(design, False)

MsgBox ("Select a Circluar Feature")

'54 corresponds to Topology Class entry in FClass
Dim graph1 As AGraphic
Set graph1 = drawdoc.GetSingleSelection(54, 2)

' Get the paper geometry corresponding to the first selected item
Dim geom1 As ZGeometry
Set geom1 = drawdoc.GetPaperGeometry(graph1)
Dim original As ZGeometry
Set original = geom1.GetOriginal

'get the design instance
Dim view1 As AHiddenLine
Set view1 = geom1.GetInstance

Dim Dimension As ADimension
Set Dimension = CadStorm.CreateDimension(ddetail, 3, original)
    
'Set the position for the dimension line
Dim position As ZVector
Set position = CadStorm.CreateVectorXYZ(0.001, 0.001, 0)
    
' Create the linear dimension line
Dim DiaDim As Object
Set DiaDim = CadStorm.CreateRadialDimLine(position, Dimension, view1)
Dim tolerance As ADimTol
Set tolerance = CadStorm.CreateDimTol(ddetail, Dimension)

Dim callout As ACallout
Set callout = CadStorm.CreateDimensionCallout(tolerance)

Dim text As ADimLineText
Dim vector As ZVector
Set text = CadStorm.CreateDimLineText(DiaDim, callout, position, 0.0035)

' 1 is for aCalloutGroup::topCenter
text.SetControlPoint 1, position
   
'Add the dimension line to the drawing.
Draw.AddDimLine DiaDim
Draw.AddCenterLineUser DiaDim

'Update the views

End Function



Function DrawRadialDimension(design, drawdoc)

Dim CadStorm As Object
Set CadStorm = CreateObject("CadStorm.Application")

' Get the Drawing Object pointer
Dim Draw As ADrawing
Set Draw = drawdoc.GetDrawing

Dim ddetail As ADesignDetail
Set ddetail = Draw.GetDetail(design, False)

MsgBox ("Select ONE radial item")

'54 corresponds to Topology Class entry in FClass
Dim graph1 As AGraphic
Set graph1 = drawdoc.GetSingleSelection(54, 2)

' Get the paper geometry corresponding to the first selected item
Dim geom1 As ZGeometry
Set geom1 = drawdoc.GetPaperGeometry(graph1)
Dim original As ZGeometry
Set original = geom1.GetOriginal

' get the design instance
Dim view1 As AHiddenLine
Set view1 = geom1.GetInstance

Dim Dimension As ADimension
Set Dimension = CadStorm.CreateDimension(ddetail, 2, original)
    
'Set the position for the dimension line
Dim position As ZVector
Set position = CadStorm.CreateVectorXYZ(0.001, 0.001, 0)
    
' Create the radial dimension line
'Dim RadDim As Object
Dim RadDim As ARadialDimLine
Set RadDim = CadStorm.CreateRadialDimLine(position, Dimension, view1)

Dim dimline As ADimLine
Set dimline = RadDim


Dim dimlinecenter As ZVector
Set dimlinecenter = dimline.GetCenter()

Dim direction As ZDirection
'Set direction = dimline.GetDirection(point)
Dim dimlinepos As ZVector
Set dimlinepos = CadStorm.CreateVectorXYZ(0.1, 0.1, 0.1)
dimline.SetPosition dimlinepos
Set dimlinepos = dimline.GetPosition()

Dim calloutgroup As AObjectSet
Set calloutgroup = dimline.GetCalloutGroups()
Dim calloutgroupcount As Integer
calloutgroupcount = calloutgroup.GetCount()

Dim leaders As AObjectSet
Set leaders = dimline.GetLeaders()
Dim leaderscount As Integer
leaderscount = leaders.GetCount()

Dim def As ADimension
Set def = dimline.GetDefinition()

Dim tolerance As ADimTol
Set tolerance = CadStorm.CreateDimTol(ddetail, Dimension)
Dim callout As ACallout
Set callout = CadStorm.CreateDimensionCallout(tolerance)
Dim text As ADimLineText
Dim vector As ZVector
Set text = CadStorm.CreateDimLineText(RadDim, callout, position, 0.0035)

' 1 is for aCalloutGroup::topCenter
text.SetControlPoint 1, position
   
'Add the dimension line to the drawing.
Draw.AddDimLine RadDim
Draw.AddCenterLineUser RadDim

'Update the views

End Function


Function DrawGeomTol(design, drawdoc)

Dim CadStorm As Object
Set CadStorm = CreateObject("CadStorm.Application")

' Get the Drawing Object pointer
Dim Draw As ADrawing
Set Draw = drawdoc.GetDrawing

Dim ddetail As ADesignDetail
Set ddetail = Draw.GetDetail(design, False)

MsgBox ("Select a Drawing Feature")

'32 corresponds to GraphicClass entry in FClass
Dim graph As AGraphic
Set graph = drawdoc.GetSingleSelection(32, 2)

'get paper geometry
Dim geom As ZGeometry
Set geom = drawdoc.GetPaperGeometry(graph)

' create geomtol
Dim tolerance As AGeomTol
Set tolerance = CadStorm.CreateGeomTol(ddetail, geom)
Dim callout As AGeomTolCallout
Set callout = CadStorm.CreateGeomTolCallout(tolerance)

tolerance.SetTolerance 0.01
tolerance.SetType 1

Dim newgeomtol As AGeomTol
Set newgeomtol = callout.GetTolerance()
newgeomtol.SetTolerance 0.02
newgeomtol.SetType 2
newgeomtol.SetFeatureModifier 2

'Set the position for the dimension line
Dim textLocation As ZVector
Set textLocation = CadStorm.CreateVectorXYZ(0.1, 0.1, 0)

Dim calloutgroup As ACalloutGroup
' 0.005 is the text height
Set calloutgroup = CadStorm.CreateCalloutGroup(callout, textLocation, 0.005)
calloutgroup.SetControlPoint 1, textLocation

Dim tolerance11 As AGeomTol
Set tolerance11 = CadStorm.CreateGeomTol(ddetail, geom)

' set the tolerance to 0.01
tolerance11.SetTolerance 0.01
tolerance11.SetType 1

'create geomtolcallout
Dim callout11 As AGeomTolCallout
Set callout11 = CadStorm.CreateGeomTolCallout(tolerance11)
calloutgroup.InsertCallout callout11, callout

Dim retval As Boolean
retval = calloutgroup.MoveCallout(callout, 1, True)
Draw.AddCalloutGroup calloutgroup

' create feature leader
Dim leader As ALeader
Set leader = CadStorm.CreateFeatureLeader(calloutgroup, geom)
Draw.AddLeader leader
Draw.AddCenterLineUser leader

' update view

End Function


Function DrawDatum(design, drawdoc)

Dim CadStorm As Object
Set CadStorm = CreateObject("CadStorm.Application")

' Get the Drawing Object pointer
Dim Draw As ADrawing
Set Draw = drawdoc.GetDrawing

Dim ddetail As ADesignDetail
Set ddetail = Draw.GetDetail(design, False)

MsgBox ("Select a Drawing Feature")

'32 corresponds to GraphicClass entry in FClass
Dim graph As AGraphic
Set graph = drawdoc.GetSingleSelection(32, 2)

' get the paper geometry
Dim geom As ZGeometry
Set geom = drawdoc.GetPaperGeometry(graph)

' Creating Datum
Dim tolerance1 As ADatum
Set tolerance1 = CadStorm.CreateDatum(ddetail, geom)
Dim callout1 As ADatumCallout
Set callout1 = CadStorm.CreateDatumCallout(tolerance1)

'Set the position for the dimension line
Dim textLocation1 As ZVector
Set textLocation1 = CadStorm.CreateVectorXYZ(0.2, 0.2, 0)

Dim calloutgroup1 As ACalloutGroup
' 0.005 is the text height
Set calloutgroup1 = CadStorm.CreateCalloutGroup(callout1, textLocation1, 0.005)
calloutgroup1.SetControlPoint 1, textLocation1

Draw.AddCalloutGroup calloutgroup1

'create feature leader
Dim leader1 As ALeader
Set geom = tolerance1.GetGeometry()
Set leader1 = CadStorm.CreateFeatureLeader(calloutgroup1, geom)

' create newpoint which to be termination point
Dim newpoint As ZVector
Set newpoint = CadStorm.CreateVectorXYZ(0.1, 0.1, 0.1)

leader1.SetTerminationPoint newpoint
leader1.SetPerpendicular
leader1.SetCalloutGroup calloutgroup1

' get the callout group
Dim calloutgroup2 As ACalloutGroup
Set calloutgroup2 = leader1.GetCalloutGroup()

' set terminator and shoulder length
leader1.SetTerminator (1)
leader1.SetShoulderLength (0.1)
leader1.RemoveJogPoints

Draw.AddLeader leader1
Draw.AddCenterLineUser leader1

' update the views

End Function


Function DrawNote(design, drawdoc)

Dim CadStorm As Object
Set CadStorm = CreateObject("CadStorm.Application")

' Get the Drawing Object pointer
Dim Draw As ADrawing
Set Draw = drawdoc.GetDrawing

Dim ddetail As ADesignDetail
Set ddetail = Draw.GetDetail(design, False)

MsgBox ("Select ONE Item")

'32 corresponds to GraphicClass entry in FClass
Dim graph As AGraphic
Set graph = drawdoc.GetSingleSelection(32, 2)

' get the paper geometry of selected item
Dim geom As ZGeometry
Set geom = drawdoc.GetPaperGeometry(graph)

' Creating Note
Dim tolerance2 As ANote
Set tolerance2 = CadStorm.CreateNote(Draw, "My Note")
Dim callout2 As ANoteCallout
Set callout2 = CadStorm.CreateNoteCallout(tolerance2)

tolerance2.SetText ("New Note")

'Set the position for the dimension line
Dim textLocation2 As ZVector
Set textLocation2 = CadStorm.CreateVectorXYZ(0.1, 0.2, 0)

Dim calloutgroup2 As ACalloutGroup
' 0.005 is the text height
Set calloutgroup2 = CadStorm.CreateCalloutGroup(callout2, textLocation2, 0.005)
calloutgroup2.SetControlPoint 1, textLocation2
callout2.SetBoxed (True)
Draw.AddCalloutGroup calloutgroup2

' create feature leader
Dim leader2 As ALeader
Set leader2 = CadStorm.CreateFeatureLeader(calloutgroup2, geom)
Draw.AddLeader leader2
Draw.AddCenterLineUser leader2

'update view

End Function


